@extends('layout.master')

@section('title', 'Create Bills')

@section('content')

    <section>
        <div class="row">
            <div class="col-12">

                <div class="card">

                    <div class="card-content">
                        <div class="card-header">
                             <h1>Create Bills</h1>

                        </div>
                        <div class="card-body card-dashboard">
                            @include('inc.messages')
                            <form class="form" method="POST" action="{{route('bill.store')}}" enctype="multipart/form-data" id="add_bill_form">
                                @csrf
                                <div class="form-body">
                                    <div class="row">
                                        <input type="hidden" name="bill_id" value="{{$bill->id}}">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lot_number">Voucher #</label>
                                                <input type="text" id="number" class="form-control"
                                                     name="number" value="{{$month}}" readonly required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lot_number">Voucher #</label>
                                                <input type="text" id="number" class="form-control"
                                                     name="number" value="{{$month}}" readonly required>
                                            </div>
                                        </div>

                                    </div>

                                </div>
                                <div class="form-actions">

                                    <button type="submit" class="btn btn-primary">
                                        <i class="la la-check-square-o"></i> Generate
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/custom.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/icheck.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/selects/select2.min.css')}}">
@endsection
@section('js')
    <script src="{{asset('app-assets/vendors/js/forms/select/select2.full.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('app-assets/vendors/js/forms/validation/additional-methods.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datatable_buttons.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/extensions/toastr.min.js')}}" type="text/javascript"></script>


    <script type="text/javascript">
    function cacl_total(params) {
        console.log(params);


}

function cacl_sub_total(params) {
    var qty = parseFloat(params.parentElement.previousElementSibling.children[0].value);
    params.parentElement.nextElementSibling.children[0].value=qty*parseFloat(params.value)
    var t =0;
    for (var index = 0; index < document.getElementsByClassName('amount').length; index++) {
            var total = document.getElementsByClassName('amount')[index];
                t+= parseFloat(total.value);
        }
    document.getElementById('total').value = t;
}
        $(document).ready(function() {



            $('#number').inputmask("9999-9999999");
            $('.bill_qtyy').inputmask({
                'alias': 'numeric'
            });

        });
        $('#customer_id').prepend('<option value="" selected="selected"></option>').select2({
                width: '100%',
                placeholder: 'Select Customer*',
                dropdownParent:$('#add_outward_form')

            });

            $( "#add_outward_form" ).validate({
                errorClass:"danger",
                errorPlacement: function(error, element) {
                    error.addClass('w-100').appendTo(element.parents('.form-group'));
                },
                submitHandler: function(form) {
                    if(errors === 1){
                        return false;
                    }else{
                        swal({
                                        title: 'Are You Sure?',
                                        text: 'Select Yes to Create Outward!',
                                        icon: 'warning',
                                        buttons: {
                                            cancel: {
                                                text: 'No',
                                                value: null,
                                                visible: true,
                                                closeModal: true,
                                            },
                                            confirm: {
                                                text: 'Yes',
                                                value: true,
                                                visible: true,
                                                closeModal: true
                                            }
                                        },
                                        closeOnClickOutside: false,
                                        closeOnEsc: false,
                                        dangerMode: true
                                    }).then(function (confirm) {
                                        if (confirm) {
                                            form.submit();
                                        }
                                    });
                        $(form).find('button[type=submit]').attr('disabled', 'disabled');

                    }

                }
            });

    </script>

@endsection
