@extends('layout.master')

@section('title', 'Attendance Report')

@section('content')

    <section>
        <div class="row">
            <div class="col-12">

                <div class="card">

                    <div class="card-content">
                        <div class="card-header">
                             <h1>Attendance Report</h1>

                        </div>
                        <div class="card-body card-dashboard">
                            @include('inc.messages')
                            <table class="table table-bordered datatable" id="datatable" style="z-index: 3;">
                                <thead>
                                    <tr role="row" class="bg-primary white">
                                        <th class="border-primary border-darken-1">S. No.</th>
                                        <th class="border-primary border-darken-1">Member #</th>
                                        <th class="border-primary border-darken-1">Date</th>
                                        <th class="border-primary border-darken-1">Time</th>
                                    </tr>
                                </thead>
                            </table>


                            <div class="modal fade" id="info_modal" role="dialog" aria-labelledby="info_modal_title" aria-hidden="true">
                                <div class="modal-dialog modal-sm" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                        </div>
                                        <div class="modal-body text-center">
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/selects/select2.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/extensions/toastr.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/icheck.css')}}">
    <style type="text/css">
        table.dataTable {
            font-size: 12px;
        }

        table.dataTable thead tr th {
            padding-left: 0.5em;
            white-space: normal;
            word-wrap: break-word;
        }

        table.dataTable thead tr th:before,
        table.dataTable thead tr th:after {
            height: 20px;
            margin-bottom: -10px;
            bottom: 50% !important;
        }

        table.dataTable tbody tr td {
            padding-left: 0.5em;
            padding-right: 0.5em;
        }

        table.dataTable tbody tr td.select-checkbox:before {
            top: 50%;
            border-color: #64a0d2;
        }

        table.dataTable tbody tr.selected td.select-checkbox:after {
            top: 50%;
            text-shadow: none;
        }

        .btn-group .dropdown-menu .dropdown-item {
            white-space: normal;
        }

        #toast-bottom-center.toast-container {
            text-align: center;
        }

        #toast-bottom-center.toast-container .toast {
            display: table;
            width: auto !important;
            text-align: left;
        }
    </style>
@endsection

@section('js')
    <script src="{{asset('app-assets/vendors/js/extensions/toastr.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('app-assets/vendors/js/forms/icheck/icheck.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/js/scripts/forms/checkbox-radio.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/select/select2.full.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('app-assets/vendors/js/forms/validation/additional-methods.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datatable_buttons.js')}}" type="text/javascript"></script>

    <script type="text/javascript">
        $(document).ready(function() {


            $('#father_id').prepend('<option value="" selected="selected"></option>').select2({
                width: '100%',
                placeholder: 'Select Father*',
                dropdownParent:$('#add_father_form')

            })

       var selected_rows = [];

            //table start

               var table =  $('.datatable').DataTable({
                   dom: '<"d-inline-block"l><"pull-right"B>tipr',

                        buttons: [

                        {
                        extend: 'excel',
                        title: 'All Members',
                        className: 'btn btn-primary',
                        text: '<i class="la la-file-excel-o"></i> Excel',
                        },'reset'

                        ],
                    select: {
                    info: false,
                    style: 'multi',
                    selector: 'td.select-checkbox',
                    className: 'selected bg-success bg-lighten-5 success'
                },
                    scrollX: false,
                    lengthMenu: [[50, 100, 500, 1000, -1], [50, 100, 500, 1000, 'All']],
                    pageLength: 50,
                    pagingType: 'full_numbers',
                    processing: true,
                    language: {
                        processing: data_table_loader
                    },
                    serverSide: true,
                    ajax: '{{ route('attendamce_list') }}',
                   rowId: 'id',
                    order: [[1, 'desc']],
                    columns: [
                        {data: 'id', orderable: false, searchable: false, name: 'serial_number', class: 'text-center align-middle serial_number', targets: 0, render: function (data, type, row) {return '';}},
                        {data: 'member_number', name: 'members.member_number', class: 'align-middle text-center member_number'},
                        {data: 'date', name: 'a.attendance_date', class: 'align-middle text-center date'},
                        {data: 'time', name: 'a.attendance_time', class: 'align-middle text-center time'},
                    ],
                   rowCallback: function(row, data, index) {
                       var info = table.page.info();

                       $('td:eq(0)', row).html(index + 1 + info.page * info.length);
                       if ($.inArray(data.id, selected_rows) !== -1) {
                            table.row(row).select();
                        }
                    //     if(data.status == 0){
                    //      $('tr', row).addClass('select-checkbox disabled');

                    //      $('td:eq(0)', row).addClass('select-checkbox disabled');

                    //    }

                   },
                   initComplete: function() {
                       var search = $('<tr role="row" class="bg-primary white search"></tr>').appendTo(this.api().table().header());

                       var td = '<td style="padding:5px;" class="border-primary border-darken-1"><fieldset class="form-group m-0 position-relative has-icon-right"></fieldset></td>';
                       var input = '<input type="text" class="form-control form-control-sm input-sm primary">';
                       var icon = '<div class="form-control-position primary"><i class="la la-search"></i></div>';
                      this.api().columns().every(function(column_id) {
                           var column = this;
                           var header = column.header();
                           var gender_select = '<select name="status_select" id="gender_select" class="select2 form-control">' +
                        '<option value="0">Male</option>' +
                        '<option value="1">Female</option>' +
                        '</select>';
                           if ($(header).is('.select') || $(header).is('.serial_number') || $(header).is('.action') || $(header).is('.profile_pic') ) {
                               $(td).appendTo($(search));
                           }
                           else if($(header).is('.gender')){
                            $(gender_select).appendTo($(search))
                                .on( 'change', function () {
                                    column.search($(this).val(), false, false, true).draw();
                                } ).wrap(td);
                        }
                           else {
                               var current = $(input).appendTo($(search)).on('change', function() {
                                   column.search($(this).val(), false, false, true).draw();
                               }).wrap(td).after(icon);

                               if (column.search()) {
                                   current.val(column.search());
                               }
                           }
                       });

                    $("#gender_select").prepend('<option value="" selected></option>').select2({
                        placeholder: "Select Gender",
                        width:'100%',
                        containerCssClass: 'select-xs',
                        dropdownCssClass: 'form-control-sm p-0'
                    });
                       this.api().table().columns.adjust();

                   }
                });
                $('#datatable tbody').on('click', 'tr td.select-checkbox', function() {
                    var id = parseInt($(this).parent('tr').attr('id'));
                    var index = $.inArray(id, selected_rows);
                    if (index === -1) {
                        selected_rows.push(id);
                    }
                    else {
                        selected_rows.splice(index, 1);
                    }

                    if (selected_rows.length > 0) {
                        table.button('.activate_members').enable();

                    }
                    else {
                        table.button('.activate_members').disable();

                    }
                    console.log(selected_rows);
                });



        $('#datatable tbody').on('click', 'tr td.profile_pic button', function() {
                var id = parseInt($(this).parents('tr').attr('id'));

                $('#info_modal .modal-body').html('');

                $.ajax({
                    url: '{!! route('members.profile_picture') !!}',
                    method: 'POST',
                    data: {
                        '_token': '{{ csrf_token() }}',
                        'id': id
                    }
                })
                    .done(function (data) {
                        if (data) {
                            var head = '';
                            var bag_numbers = '';
                            head = '<h4 class="modal-title" id="info_modal_title">Member Picture</h4>' +
                                '<button type="button" class="close" data-dismiss="modal" aria-label="Close">' +
                                '<span aria-hidden="true">×</span>\n' +
                                '</button>';

                                            bag_numbers = '<img src="{!! asset("'+data+'") !!}" style="width:250px;"/>';


                            $('#info_modal .modal-header').html(head);
                            $('#info_modal .modal-body').html(bag_numbers);

                            $('#info_modal').modal('show');
                        }
                    });
        });


       $('body').on('click','button.edit_member',function () {
               var id = $(this).parents('tr').attr('id');
                // $.get( ""+id+"/editmember");

                window.location = 'members/'+id+'/editmember/';

       });


        $('body').on('click','button.status',function () {

            var id = table.row( $(this).parents('tr') ).data().id;
            console.log(id);
            swal({
                title: 'Are You Sure?',
                text: 'Select Yes to Delete Member!',
                icon: 'warning',
                buttons: {
                    cancel: {
                        text: 'No',
                        value: null,
                        visible: true,
                        closeModal: true,
                    },
                    confirm: {
                        text: 'Yes',
                        value: true,
                        visible: true,
                        closeModal: true
                    }
                },
                closeOnClickOutside: false,
                closeOnEsc: false,
                dangerMode: true
            }).then(function (confirm) {
                if (confirm) {
                    $.ajax({
                        url: '{!! route('members.delete') !!}',
                        method: 'POST',
                        data: {
                            'id': id,
                            '_token': '{{ csrf_token() }}'
                        }
                    }).done(function(data) {
                        console.log(data);
                        if (data.status) {
                            table.draw(true);
                            toastr.success(data.success, 'Success!', {
                                positionClass: 'toast-bottom-center',
                                containerId: 'toast-bottom-center'
                            });

                        }
                    });
                }
            });

        });

            $('input.icheck').iCheck({
                checkboxClass: 'icheckbox_squaret-red',
                radioClass: 'iradio_square-red'
            });
        });




    </script>

@endsection
