@extends('layout.master')

@section('title', 'All Bills')

@section('content')

    <section>
        <div class="row">
            <div class="col-12">

                <div class="card">

                    <div class="card-content">
                        <div class="card-header">
                             <h1>All Bills</h1>

                        </div>
                        <div class="card-body card-dashboard">
                            @include('inc.messages')
                            <table class="table table-bordered datatable" id="datatable" style="z-index: 3;">
                                <thead>
                                    <tr role="row" class="bg-primary white">
                                        <th class="border-primary border-darken-1">S No.</th>
                                        <th class="border-primary border-darken-1">Bill Date</th>
                                        <th class="border-primary border-darken-1">Member Name</th>
                                        <th class="border-primary border-darken-1">Member #</th>
                                        <th class="border-primary border-darken-1">Amount</th>
                                        <th class="border-primary border-darken-1">Status</th>
                                        <th class="border-primary border-darken-1">Action</th>
                                    </tr>
                                </thead>
                            </table>


                            <div class="modal fade" id="info_modal" role="dialog" aria-labelledby="info_modal_title" aria-hidden="true">
                                <div class="modal-dialog modal-sm" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                        </div>
                                        <div class="modal-body text-center">
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/selects/select2.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/extensions/toastr.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/icheck.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/modal/sweetalert.css')}}">

    <style type="text/css">
        table.dataTable {
            font-size: 12px;
        }

        table.dataTable thead tr th {
            padding-left: 0.5em;
            white-space: normal;
            word-wrap: break-word;
        }

        table.dataTable thead tr th:before,
        table.dataTable thead tr th:after {
            height: 20px;
            margin-bottom: -10px;
            bottom: 50% !important;
        }

        table.dataTable tbody tr td {
            padding-left: 0.5em;
            padding-right: 0.5em;
        }

        table.dataTable tbody tr td.select-checkbox:before {
            top: 50%;
            border-color: #64a0d2;
        }

        table.dataTable tbody tr.selected td.select-checkbox:after {
            top: 50%;
            text-shadow: none;
        }

        .btn-group .dropdown-menu .dropdown-item {
            white-space: normal;
        }

        #toast-bottom-center.toast-container {
            text-align: center;
        }

        #toast-bottom-center.toast-container .toast {
            display: table;
            width: auto !important;
            text-align: left;
        }
    </style>
@endsection

@section('js')
    <script src="{{asset('app-assets/vendors/js/extensions/toastr.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('app-assets/vendors/js/forms/icheck/icheck.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/js/scripts/forms/checkbox-radio.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/select/select2.full.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('app-assets/vendors/js/forms/validation/additional-methods.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/extensions/sweetalert.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('js/datatable_buttons.js')}}" type="text/javascript"></script>

    <script type="text/javascript">
        $(document).ready(function() {



       var selected_rows = [];

            //table start

               var table =  $('.datatable').DataTable({
                   dom: '<"d-inline-block"l><"pull-right"B>tipr',

                        buttons: [

                        {
                        extend: 'excel',
                        title: 'Job Sheets',
                        className: 'btn btn-primary',
                        text: '<i class="la la-file-excel-o"></i> Excel',
                        },'reset'

                        ],
                    select: {
                    info: false,
                    style: 'multi',
                    selector: 'td.select-checkbox',
                    className: 'selected bg-success bg-lighten-5 success'
                },
                    scrollX: false, scrollY: '500px',
                    lengthMenu: [[50, 100, 500, 1000, -1], [50, 100, 500, 1000, 'All']],
                    pageLength: 50,
                    pagingType: 'full_numbers',
                    processing: true,
                    language: {
                        processing: data_table_loader
                    },
                    serverSide: true,
                    ajax: '{{ route('bill.list') }}',
                   rowId: 'b_id',
                    order: [[1, 'desc']],
                    columns: [
                        {orderable: false, searchable: false, name: 'serial_number', class: 'align-middle serial_number', targets: 1, render: function (data, type, row) {return '';}},
                        {data: 'date', name: 'bills.date', class: 'align-middle text-center date'},
                        {data: 'member_name', name: 'm.full_name', class: 'align-middle text-center name'},
                        {data: 'member_number', name: 'm.member_number', class: 'align-middle text-center member_number'},
                        {data: 'amount', name: 'bills.amount', class: 'align-middle text-center amount'},
                        {data: 'status', name: 'bills.status', class: 'align-middle text-center status'},
                        {data: 'action', name: 'action', class: 'text-center align-middle action p-1', orderable: false, searchable: false}
                    ],
                   rowCallback: function(row, data, index) {
                       var info = table.page.info();

                       $('td:eq(0)', row).html(index + 1 + info.page * info.length);
                    //    console.log(info);
                    //    if ($.inArray(data.id, selected_rows) !== -1) {
                    //         table.row(row).select();
                    //     }
                    //     if(data.status == 0){
                    //      $('tr', row).addClass('select-checkbox disabled');

                    //      $('td:eq(0)', row).addClass('select-checkbox disabled');

                    //    }

                   },
                   initComplete: function() {
                       var search = $('<tr role="row" class="bg-primary white search"></tr>').appendTo(this.api().table().header());

                       var td = '<td style="padding:5px;" class="border-primary border-darken-1"><fieldset class="form-group m-0 position-relative has-icon-right"></fieldset></td>';
                       var input = '<input type="text" class="form-control form-control-sm input-sm primary">';
                       var icon = '<div class="form-control-position primary"><i class="la la-search"></i></div>';
                      this.api().columns().every(function(column_id) {
                           var column = this;
                           var header = column.header();
                           if ($(header).is('.select') || $(header).is('.serial_number') || $(header).is('.action') ) {
                               $(td).appendTo($(search));
                           }
                           else {
                               var current = $(input).appendTo($(search)).on('change', function() {
                                   column.search($(this).val(), false, false, true).draw();
                               }).wrap(td).after(icon);

                               if (column.search()) {
                                   current.val(column.search());
                               }
                           }
                       });
                       this.api().table().columns.adjust();

                   }
                });



    //    $('body').on('click','button.create_outward',function () {
    //            var id = $(this).parents('tr').attr('id');
    //             // $.get( "/outward/create/"+id);
    //            console.log(id);
    //             window.location = 'outward/create/'+id;

    //    });
       $('body').on('click','button.pay_bill',function () {
               var id = $(this).parents('tr').attr('id');
                // $.get( ""+id+"/editmember");
                window.location = 'voucher/'+id+'/create';

       });

    //    $('body').on('click','button.print_bill',function () {
    //            var id = $(this).parents('tr').attr('id');
    //             // $.get( ""+id+"/editmember");
    //             window.location = 'bill/'+id+'/print';

    //    });




       $('body').on('click','button.delete_bill',function () {
               var id = $(this).parents('tr').attr('id');
                // $.get( ""+id+"/editmember");
                swal({
                        title: 'Are you sure?',
                        text: 'You want to delete Bill?',
                        icon: 'warning',
                        buttons: {
                            cancel: {
                                text: 'Close',
                                value: null,
                                visible: true,
                                closeModal: true,
                            },
                            confirm: {
                                text: 'Delete',
                                value: true,
                                visible: true,
                                closeModal: true
                            }
                        },
                        closeOnClickOutside: false,
                        closeOnEsc: false,
                        dangerMode: true
                    }).then(function(confirm) {
                        if (confirm) {
                            $.ajax({
                                url: '{!! route('bill.delete') !!}',
                                method: 'POST',
                                data: {
                                    'id': id,
                                    '_token': '{{ csrf_token() }}'
                                }
                            }).done(function(data) {
                                if (data.status) {
                                    table.draw(true);
                                    toastr.success(data.success, 'Success!', {
                                        positionClass: 'toast-bottom-center',
                                        containerId: 'toast-bottom-center'
                                    });

                                }
                            });
                        }
                    });

                // window.location = ''+id+'/editmember/';

       });




            $('input.icheck').iCheck({
                checkboxClass: 'icheckbox_squaret-red',
                radioClass: 'iradio_square-red'
            });
        });




    </script>

@endsection
