<?php

namespace App\Http\Controllers;

use App\Bill;
use App\BillProcess;
use App\Customer;
use App\Inward;
use App\Member;
use App\MembershipPlan;
use App\Outward;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class BillController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {

        $this->middleware('UserPermission');
    }

    public function index()
    {
        return view('bill.index');
    }

    function list() {
        $bill = Bill::leftjoin('members as m', 'm.id', '=', 'bills.member_id')
            ->leftjoin('membership_plans as mp', 'mp.id', '=', 'm.membership_plan_id')
            ->select('bills.id', 'bills.amount', 'bills.date', 'm.full_name as member_name', 'm.member_number as member_number', 'bills.id as b_id', 'mp.name as plan','bills.status');
        $datatable = DataTables::of($bill)->addColumn('action', function ($bill) {
            $dropdown = '
            <div class="btn-group">
            <button type="button" class="btn btn-sm btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Actions</button>
            <div class="dropdown-menu dropdown-menu-sm">';
            // $dropdown .= '<button type="button" class="dropdown-item print_bill"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-printer"></i></div><div class="col-9 offset-1">Print</div></button>';
            // $dropdown .= '<button type="button" class="dropdown-item edit_bill"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-edit"></i></div><div class="col-9 offset-1">Edit</div></button>';
            // $dropdown .= '<button type="button" class="dropdown-item delete_bill"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-minus-circle"></i></div><div class="col-9 offset-1">Delete</div></button>';
            $dropdown .= '<button type="button" class="dropdown-item pay_bill"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-printer"></i></div><div class="col-9 offset-1">Pay</div></button>';

            return $dropdown;

        })
            ->editColumn('status', function ($bill) {
                if($bill->status == 1){
                    return 'PAID';
                }else{
                    return 'UN-PAID';

                }
            })->rawColumns(['action']);

        return $datatable->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $month = Carbon::today()->format('Y-m');
        return view('bill.create', compact('month'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $last_month = Bill::all()->last();
        if ($last_month) {
            if ($last_month->date == $request->billig_month) {
                return redirect()->back()->with('error', 'Bills Already Generated');
            } else {
                $members = Member::where('status', 1)->get();
                foreach ($members as $member) {
                    $amount = MembershipPlan::find($member->membership_plan_id);
                    $bill = new Bill;
                    $bill->member_id = $member->id;
                    $bill->amount = $amount->fee;
                    $bill->date = $request->billig_month;
                    $bill->save();
                }
            }
            return view('bill.index')->with('success', 'Bill Created Successfully');
        } else {
            $members = Member::where('status', 1)->get();
            foreach ($members as $member) {
                $amount = MembershipPlan::find($member->membership_plan_id);

                $bill = new Bill;
                $bill->member_id = $member->id;
                $bill->amount = $amount->fee;
                $bill->date = $request->billig_month;
                $bill->save();
            }
            return view('bill.index')->with('success', 'Bill Created Successfully');

        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Bill  $bill
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $bill = Bill::find($id);
        return view('bill.show', compact('bill'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Bill  $bill
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $bill = Bill::find($id);
        return view('bill.edit', compact('bill'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Bill  $bill
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $bill = Bill::find($id);
        $bill->date = $request->date;
        $bill->save();
        BillProcess::where('bill_id', $id)->delete();

        foreach ($request->bill_process as $key => $value) {
            $bill_process = new BillProcess;
            $bill_process->rate = $value;
            $bill_process->inward_process_id = $key;
            $bill_process->bill_id = $bill->id;
            $bill_process->save();

        }
        return redirect('bill')->with('success', 'Bill Updated ');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Bill  $bill
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $bill = Bill::find($request->id);
        $bill->status = 0;
        $bill->save();
        return response()->json(['status' => 1, 'success' => 'Bill Deleted']);
    }

    public function bill_report_index()
    {
        $customers = Customer::where('status', 1)->get();

        return view('bill.report', compact('customers'));
    }

    public function bill_report_list(Request $request)
    {
        $bills = Bill::join('inwards as inw', 'inw.id', '=', 'bills.inward_id')
            ->leftjoin('customers as cust', 'cust.id', '=', 'inw.customer_id')
            ->leftjoin('outwards as outw', 'outw.inward_id', '=', 'inw.id')
            ->select('bills.id', 'inw.id as inw_id', 'bills.number', 'outw.number as outw_number', 'inw.lot_number', 'bills.date', 'inw.article', 'inw.color', 'outw.outward_qty', 'cust.company_name as customer_name')
            ->where('bills.status', 1);

        if ($request->get('search_from') && $request->get('search_to')) {
            $from = $request->get('search_from');
            $to = $request->get('search_to');
            $bills->whereBetween('bills.created_at', [$from, $to]);
        }
        if ($request->get('customer_id')) {
            $customer_id = $request->get('customer_id');
            $bills->where('inw.customer_id', $customer_id);
        }
        $datatable = DataTables::of($bills)->addColumn('amount', function ($bill) {
            $amount = 0;
            $bill_process = BillProcess::where('bill_id', $bill->id)->get();
            foreach ($bill_process as $val) {
                $amount = $amount + (floatval($val->inward_process->quantity) * floatval($val->rate));
            }
            return $amount;
            // $process = InwardProcess::where('inward_id',$inward->id)->get()->last();
            // return $process->machine->name;
            // return Machine::find($inwards->mac_id)->name;
            // return $inwards->mac_id;
        })
            ->editColumn('date', function ($bills) {
                $date = date_create($bills->date);
                return date_format($date, "d-m-Y");
            });
        return $datatable->make(true);
    }

    function print($id) {
        $bill = Bill::find($id);
        $html = '
        <!doctype html>
        <html lang="en">
          <head>
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

            <link rel="stylesheet" type="text/css" href="' . asset('app-assets/css/bootstrap.min.css') . '">

            <title>BILL</title>

            <style>
            @media print {
                .pagebreak { page-break-before: always; } /* page-break-after works, as well */
            }
              @page {
                size: A4 portrait;
              }

              * {
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
              }

              body {
                background: none !important;
                color: #09262e !important;
                font-size: 0.9rem !important;
              }

              hr {
                border-top: 1px dashed #000000;
              }

              table.table-bordered {
                page-break-inside: avoid;
              }

              table.table-bordered tbody tr td {
                width: 12.5% !important;
                border: 1px solid #09262e !important;
              }

              .color.primary {
                background: #c8c8c8 !important;
              }

              .color.secondary {
                background: #ebebeb !important;
              }

              .border {
                border: 1px solid #09262e !important;
              }

              .border.twice {
                border-width: 2px !important;
              }

              .border.twice-top {
                border-top-width: 2px !important;
              }

              .border.twice-bottom {
                border-bottom-width: 2px !important;
              }

              .border.twice-left {
                border-left-width: 2px !important;
              }

              .border.twice-right {
                border-right-width: 2px !important;
              }

              td.replacement span {
                width: 22px;
              }

              td.replacement span img {
                display: block;
                width: 100%;
                margin: auto;
                background: #c8c8c8;
                border-radius: 25px;
              }

              .invoice table.table-bordered tbody tr td {
                width: auto !important;
              }
              .center{
                  text-align: center;
              }
            </style>
          </head>
          <body>
            <div>
            ';

        $date = date_create($bill->date);

        $html .= '<div class="row">
              <div class="col-10 center">
                  <h2 style="margin-left:182px">JOB WORK BILL</h2>
                  <h6 style="margin-left:186px">(TANNERY COPY)</h6>
              </div>
              <div class="col-2">
                  <img src="' . asset('app-assets/images/logo/logo.png') . '" width="100" class="d-block mx-auto">
              </div>
          </div>
          <br>
    <br>
    <div class="row">
        <div class="col-6 center">
            <div class="form-group" style="margin-top: 38px">
                <label for="customer_name">Customer Name: </label><strong>     ' . ucfirst($bill->inward->customer->company_name) . '</strong>

            </div>
        </div>
        <div class="col-6 center">
            <div class="form-group">
                <label style="margin-left:100px;" for="customer_name">BILL Date: </label>     ' . date_format($date, "d-m-Y") . '

            </div>
            <div class="form-group">
                <label style="margin-left:82px;" for="customer_name">BILL #: </label><strong>     ' . $bill->number . '</strong>

            </div>
            <div class="form-group">
                <label style="margin-left:105px;" for="customer_name">Outward #: </label>     ' . $bill->inward->outward->number . '

            </div>
        </div>


    </div>
    <br>
    <div class="row" style="border: 1px solid; padding-top: 20px;">
        <div class="col-4 center">
            <div class="form-group">
                <label for="customer_name">LOT #: </label><strong>     ' . $bill->inward->lot_number . '</strong>

            </div>
        </div>
        <div class="col-4 center">
            <div class="form-group">
                <label for="customer_name">Article Name: </label>     ' . $bill->inward->article . '

            </div>
        </div>
        <div class="col-4 center">
            <div class="form-group">
                <label for="customer_name">Color: </label>     ' . $bill->inward->color . '

            </div>
        </div>
    </div>
    <br>
    <br>
    <div class="row">
        <table class="table table-sm table-bordered border twice">
            <thead>
               <tr class="center">
                <th>Date</th>
                <th>Machine</th>
                <th>Quantity</th>
                <th>Rate</th>
                <th>Amount</th>
               </tr>
            </thead>
            <tbody>';
        $rate = 0;
        $rows = 25;

        foreach ($bill->processes as $process) {
            $rows--;
            $html .= '<tr class="center">';

            $date = date_create($process->inward_process->date);

            $html .= '<td>' . date_format($date, "d-m-Y") . '</td>
                <td>' . $process->inward_process->machine->name . '</td>
                <td>' . $process->inward_process->quantity . '</td>
                <td>' . $process->rate . '</td>
                <td>' . floatval($process->rate) * floatval($process->inward_process->quantity) . '</td>
            </tr>';
            $rate += floatval($process->rate) * floatval($process->inward_process->quantity);

        }
        for ($i = 0; $i < $rows; $i++) {
            # code...
            $html .= '<tr class="center">';
            $html .= '<td>&nbsp;</td>';
            $html .= '<td>&nbsp;</td>';
            $html .= '<td>&nbsp;</td>';
            $html .= '<td>&nbsp;</td>';
            $html .= '<td>&nbsp;</td>';
        }
        $html .= '            </tbody>
              </table>
          </div>
          <br>
          <div class="row">
              <div class="col-6"></div>
              <div class="col-6 center">
                 <table class="table table-sm table-bordered border twice">
                 <tr class="border twice">
                    <th class="">TOTAl:</th>
                    <td><strong>' . number_format($rate, 2) . '</strong></td>
                 </tr>
                 <tr class="border twice">
                    <th>Less: Discount Allowed</th>
                    <td></td>
                 </tr>
                 <tr class="border twice">
                    <th>NET TOTAl:</th>
                    <td></td>
                 </tr>
                 </table>

              </div>
          </div>
          <br>
          <br>
          <br>
          <div class="row">
              <div class="col-6 center">
                  <div class="form-group">
                      <label for=""><strong>_________________________</strong></label>
                      <br>
                      <label for="customer_name"><strong>Accounts</strong></label>

                  </div>
              </div>
              <div class="col-6 center">
                  <div class="form-group">
                      <label for=""><strong>_________________________</strong></label>
                      <br>

                      <label for="customer_name"><strong>Received By</strong></label>

                  </div>
              </div>
          </div>
          </div>
          <div class="pagebreak"> </div>
      ';

        $date = date_create($bill->date);

        //new page
        $html .= '<div class="row">
      <div class="col-10 center">
          <h2 style="margin-left:182px">JOB WORK BILL</h2>
          <h6 style="margin-left:186px">(TANNERY COPY)</h6>
      </div>
      <div class="col-2">
          <img src="' . asset('app-assets/images/logo/logo.png') . '" width="100" class="d-block mx-auto">
      </div>
  </div>
  <br>
<br>
<div class="row">
<div class="col-6 center">
    <div class="form-group" style="margin-top: 38px">
        <label for="customer_name">Customer Name: </label><strong>     ' . ucfirst($bill->inward->customer->company_name) . '</strong>

    </div>
</div>
<div class="col-6 center">
    <div class="form-group">
        <label style="margin-left:100px;" for="customer_name">BILL Date: </label>     ' . date_format($date, "d-m-Y") . '

    </div>
    <div class="form-group">
        <label style="margin-left:82px;" for="customer_name">BILL #: </label><strong>     ' . $bill->number . '</strong>

    </div>
    <div class="form-group">
        <label style="margin-left:105px;" for="customer_name">Outward #: </label>     ' . $bill->inward->outward->number . '

    </div>
</div>


</div>
<br>
<div class="row" style="border: 1px solid; padding-top: 20px;">
<div class="col-4 center">
    <div class="form-group">
        <label for="customer_name">LOT #: </label><strong>     ' . $bill->inward->lot_number . '</strong>

    </div>
</div>
<div class="col-4 center">
    <div class="form-group">
        <label for="customer_name">Article Name: </label>     ' . $bill->inward->article . '

    </div>
</div>
<div class="col-4 center">
    <div class="form-group">
        <label for="customer_name">Color: </label>     ' . $bill->inward->color . '

    </div>
</div>
</div>
<br>
<br>
<div class="row">
<table class="table table-sm table-bordered border twice">
    <thead>
       <tr class="center">
        <th>Date</th>
        <th>Machine</th>
        <th>Quantity</th>
        <th>Rate</th>
        <th>Amount</th>
       </tr>
    </thead>
    <tbody>';
        $rate = 0;
        $rows = 25;
        foreach ($bill->processes as $process) {
            $rows--;
            $html .= '<tr class="center">';

            $date = date_create($process->inward_process->date);

            $html .= '<td>' . date_format($date, "d-m-Y") . '</td>
        <td>' . $process->inward_process->machine->name . '</td>
        <td>' . $process->inward_process->quantity . '</td>
        <td>' . $process->rate . '</td>
        <td>' . floatval($process->rate) * floatval($process->inward_process->quantity) . '</td>
    </tr>';
            $rate += floatval($process->rate) * floatval($process->inward_process->quantity);

        }
        for ($i = 0; $i < $rows; $i++) {
            # code...
            $html .= '<tr class="center">';
            $html .= '<td>&nbsp;</td>';
            $html .= '<td>&nbsp;</td>';
            $html .= '<td>&nbsp;</td>';
            $html .= '<td>&nbsp;</td>';
            $html .= '<td>&nbsp;</td>';
        }

        $html .= '            </tbody>
      </table>
  </div>
  <br>
  <div class="row">
      <div class="col-6"></div>
      <div class="col-6 center">
         <table class="table table-sm table-bordered border twice">
         <tr class="border twice">
            <th class="">TOTAl:</th>
            <td><strong>' . number_format($rate, 2) . '</strong></td>
         </tr>
         <tr class="border twice">
            <th>Less: Discount Allowed</th>
            <td></td>
         </tr>
         <tr class="border twice">
            <th>NET TOTAl:</th>
            <td></td>
         </tr>
         </table>

      </div>
  </div>
  <br>
  <br>
  <br>
  <div class="row">
      <div class="col-6 center">
          <div class="form-group">
              <label for=""><strong>_________________________</strong></label>
              <br>
              <label for="customer_name"><strong>Accounts</strong></label>

          </div>
      </div>
      <div class="col-6 center">
          <div class="form-group">
              <label for=""><strong>_________________________</strong></label>
              <br>

              <label for="customer_name"><strong>Received By</strong></label>

          </div>
      </div>
  </div>
  </div>
';
        $html .= '


                        <script>
                          window.onload = function() {
                            window.print();
                          }
                        </script>
                      </body>
                    </html>
            ';

        return $html;

    }
}
