<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\RoleModulePermission;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

        $this->middleware('guest')->except('logout');
    }

    protected function attemptLogin(Request $request)
    {

        return $this->guard()->attempt(
            [
                'email' => $request->email,
                'password' => $request->password,
            ],
            $request->filled('remember')
        );
    }

    protected function authenticated(Request $request, $user)
    {
        if ($user->catalyst_status != 0) {
            Auth::guard()->logout();
            throw ValidationException::withMessages([
                $this->username() => [trans('auth.inactive')],
            ]);
        }

        $permissions = RoleModulePermission::where('role_id', $user->role)->pluck('permission_id')->toArray();
        session(['permissions' => $permissions]);

    }

    public function logout(Request $request)
    {
        $this->guard()->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return $this->loggedOut($request) ?: redirect('/');
    }
}
